#include <bits/stdc++.h>
using namespace std;

static bool readToken(istream& in, string& s) {
    if (!(in >> s)) return false;
    return true;
}

static string up(string s) {
    for (char& c : s) c = (char)toupper((unsigned char)c);
    return s;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    ifstream fin("input");
    ifstream fuser("user_out");
    ifstream fans("answer");

    if (!fin.is_open()) {
        cout << 0 << "\n";
        cerr << "SPJ: cannot open file: input\n";
        return 0;
    }
    if (!fuser.is_open()) {
        cout << 0 << "\n";
        cerr << "SPJ: cannot open file: user_out\n";
        return 0;
    }
    if (!fans.is_open()) {
        cout << 0 << "\n";
        cerr << "SPJ: cannot open file: answer\n";
        return 0;
    }

    int n;
    long long x0, y0;
    if (!(fin >> n >> x0 >> y0)) {
        cout << 0 << "\n";
        cerr << "SPJ: bad input format\n";
        return 0;
    }

    vector<long long> needx(n + 1), needy(n + 1), hasx(n + 1), hasy(n + 1);
    for (int i = 1; i <= n; i++) {
        if (!(fin >> needx[i] >> needy[i] >> hasx[i] >> hasy[i])) {
            cout << 0 << "\n";
            cerr << "SPJ: bad input format at task " << i << "\n";
            return 0;
        }
    }

    string ansTok, userTok;
    if (!readToken(fans, ansTok)) ansTok = "";
    if (!readToken(fuser, userTok)) {
        cout << 0 << "\n";
        cerr << "SPJ: user output is empty\n";
        return 0;
    }
    ansTok = up(ansTok);
    userTok = up(userTok);

    auto validate_yes = [&](istream& in, vector<int>& order_out, string& err) -> bool {
        vector<int> ord;
        ord.reserve(n);
        for (int i = 0; i < n; i++) {
            long long v;
            if (!(in >> v)) {
                err = "missing operation order numbers (need n integers)";
                return false;
            }
            if (v < 1 || v > n) {
                err = "order contains out-of-range index: " + to_string(v);
                return false;
            }
            ord.push_back((int)v);
        }
        vector<char> used(n + 1, 0);
        long long X = x0, Y = y0;
        for (int step = 0; step < n; step++) {
            int i = ord[step];
            if (used[i]) {
                err = "order contains duplicate index: " + to_string(i);
                return false;
            }
            used[i] = 1;
            if (X < needx[i] || Y < needy[i]) {
                err = "insufficient resources at step " + to_string(step + 1) +
                      ", pick i=" + to_string(i) +
                      ", have=(" + to_string(X) + "," + to_string(Y) + ")" +
                      ", need=(" + to_string(needx[i]) + "," + to_string(needy[i]) + ")";
                return false;
            }
            X += hasx[i];
            Y += hasy[i];
        }
        order_out = move(ord);
        return true;
    };

    int score = 0;

    if (userTok != "YES" && userTok != "NO") {
        cout << 0 << "\n";
        cerr << "SPJ: first token must be YES/NO, got: " << userTok << "\n";
        return 0;
    }

    if (userTok == "YES") {
        vector<int> user_order;
        string err;
        bool ok = validate_yes(fuser, user_order, err);
        if (!ok) {
            cout << 0 << "\n";
            cerr << "SPJ: user claims YES but witness is invalid: " << err << "\n";
            return 0;
        }
        score = 100;
        if (ansTok == "NO") {
            cerr << "SPJ: warning: official answer says NO, but user provides a valid YES witness; accepted.\n";
        } else if (ansTok != "YES") {
            cerr << "SPJ: warning: official answer token is not YES/NO: [" << ansTok << "], accepted by witness.\n";
        } else {
            cerr << "SPJ: accepted: valid YES witness.\n";
        }
        cout << score << "\n";
        return 0;
    }

    if (ansTok == "YES") {
        cout << 0 << "\n";
        cerr << "SPJ: user output NO but official answer is YES.\n";
        return 0;
    }
    if (ansTok != "NO") {
        cout << 0 << "\n";
        cerr << "SPJ: official answer token is not YES/NO: [" << ansTok << "]. Treat as mismatch.\n";
        return 0;
    }

    score = 100;
    cerr << "SPJ: accepted: user NO matches official NO.\n";
    cout << score << "\n";
    return 0;
}
