#include <iostream>
#include <fstream>
#include <string>
#include <vector>

std::string rtrim(const std::string &s) {
    std::string t = s;
    while (!t.empty()) {
        char c = t.back();
        if (c == ' ' || c == '\t' || c == '\r') {
            t.pop_back();
        } else {
            break;
        }
    }
    return t;
}

bool read_lines_trimmed(const std::string &path, std::vector<std::string> &lines) {
    std::ifstream fin(path);
    if (!fin.is_open()) {
        return false;
    }
    std::string line;
    while (std::getline(fin, line)) {
        lines.push_back(rtrim(line));
    }
    return true;
}

int main() {
    std::vector<std::string> ans, out;

    if (!read_lines_trimmed("answer", ans)) {
        std::cerr << "Failed to open answer file\n";
        std::cout << 0 << std::endl;
        return 0;
    }

    if (!read_lines_trimmed("user_out", out)) {
        std::cerr << "Failed to open user_out file\n";
        std::cout << 0 << std::endl;
        return 0;
    }

    if (ans.size() != out.size()) {
        std::cerr << "Wrong answer: line count mismatch, expected "
                  << ans.size() << ", got " << out.size() << "\n";
        std::cout << 0 << std::endl;
        return 0;
    }

    for (std::size_t i = 0; i < ans.size(); ++i) {
        if (ans[i] != out[i]) {
            std::cerr << "Wrong answer at line " << (i + 1) << "\n";
            std::cout << 0 << std::endl;
            return 0;
        }
    }

    std::cerr << "Accepted\n";
    std::cout << 100 << std::endl;
    return 0;
}
